/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomsQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qlabel.h>
#include <Qt/qlineedit.h>
#include <Qt/qlistwidget.h>
#include <Qt/qpushbutton.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/AtomsQtQueryPipe.hpp"

#include "Atom/atom.hpp"
#include "World.hpp"


QtDialog::AtomsQtQuery::AtomsQtQuery(string _title,QBoxLayout *_parent,QtDialog *_dialog) :
    Dialog::AtomsQuery(_title),
    parent(_parent)
{
  QHBoxLayout * thisHLayout = new QHBoxLayout();
  QVBoxLayout * thisV1Layout = new QVBoxLayout();
  QVBoxLayout * thisV2Layout = new QVBoxLayout();

  titleLabel = new QLabel(QString(getTitle().c_str()));
  inputLabel = new QLabel("Enter to add");
  inputList = new QListWidget();
  inputList->setSelectionMode(QAbstractItemView::ExtendedSelection);
  std::vector<atom *> atoms = World::getInstance().getAllAtoms();
  for (std::vector<atom *>::const_iterator iter = atoms.begin(); iter != atoms.end(); ++iter)
    inputList->insertItem((*iter)->getNr(),QString((*iter)->getNr()));

  QLineEdit* inputBox = new QLineEdit();
  inputLabel->setBuddy(inputBox);
  titleLabel->setBuddy(inputList);
  QPushButton* AddButton = new QPushButton("Add");
  AddButton->setEnabled(false);
  QPushButton* RemoveButton = new QPushButton("Remove");
  RemoveButton->setEnabled(false);

  thisV1Layout->addWidget(titleLabel);
  thisV1Layout->addWidget(inputList);
  thisV2Layout->addWidget(inputLabel);
  thisV2Layout->addWidget(inputBox);
  thisV2Layout->addWidget(AddButton);
  thisV2Layout->addWidget(RemoveButton);
  parent->addLayout(thisHLayout);
  thisHLayout->addLayout(thisV1Layout);
  thisHLayout->addLayout(thisV2Layout);

  pipe = new AtomsQtQueryPipe(&tmp,_dialog,inputList);
  connect(inputList,SIGNAL(itemSelectionChanged()),pipe,SLOT(IntegerSelected()));
  connect(AddButton,SIGNAL(Clicked()),pipe,SLOT(add()));
  connect(RemoveButton,SIGNAL(Clicked()),pipe,SLOT(remove()));
}

QtDialog::AtomsQtQuery::~AtomsQtQuery()
{
  delete pipe;
}

bool QtDialog::AtomsQtQuery::handle() {
  return true;
}

