/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qcombobox.h>
#include <Qt/qlabel.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/AtomQtQueryPipe.hpp"

#include "Atom/atom.hpp"
#include "World.hpp"

QtDialog::AtomQtQuery::AtomQtQuery(string _title,QBoxLayout *_parent,QtDialog *_dialog) :
    Dialog::AtomQuery(_title),
    parent(_parent)
{
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  inputBox = new QComboBox();
  inputBox->insertItem(-1, QString("no atom"));
  std::vector<atom *> atoms = World::getInstance().getAllAtoms();
  for (std::vector<atom *>::const_iterator iter = atoms.begin(); iter != atoms.end(); ++iter)
    inputBox->insertItem((*iter)->getNr(),QString::fromStdString((*iter)->getName()));

  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(inputBox);

  pipe = new AtomQtQueryPipe(&tmp,_dialog, inputBox);
  pipe->update(inputBox->currentIndex());
  connect(inputBox,SIGNAL(currentIndexChanged(int)),pipe,SLOT(update(int)));
}

QtDialog::AtomQtQuery::~AtomQtQuery()
{
  delete pipe;
}

bool QtDialog::AtomQtQuery::handle() {
  return true;
}


