/*
 * SerializablePotentialMock.hpp
 *
 *  Created on: 23.11.2012
 *      Author: heber
 */

#ifndef SERIALIZABLEPOTENTIALMOCK_HPP_
#define SERIALIZABLEPOTENTIALMOCK_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "Potentials/SerializablePotential.hpp"

/** This is a test implementation of a SerializablePotential for the unit test.
 *
 */
class SerializablePotentialMock : public SerializablePotential
{
public :
  SerializablePotentialMock() :
    SerializablePotential(ParticleTypes_t(1, ParticleType_t(1))),
    params(1, 0)
  {}
  ~SerializablePotentialMock() {}

  /* ==== Implementing virtual functions from SerializablePotental ==== */

  /** Return the token name of this specific potential.
   *
   * \return token name of the potential
   */
  const std::string& getToken() const
  { return potential_token; }

  /** Returns a vector of parameter names.
   *
   * This is required from the specific implementation
   *
   * \return vector of strings containing parameter names
   */
  const ParameterNames_t& getParameterNames() const
  { return paramNames; }

  /* ==== Implementing virtual functions from FunctionModel ==== */

  /** Setter for the parameters of the model function.
   *
   * \param _params set of parameters to set
   */
  void setParameters(const parameters_t &_params);

  /** Getter for the parameters of this model function.
   *
   * \return current set of parameters of the model function
   */
  parameters_t getParameters() const
  { return params; }

  /** Getter for the number of parameters of this model function.
   *
   * \return number of parameters
   */
  size_t getParameterDimension() const
  { return 1; }


  enum parameter_enum_t {
    dummy_constant=0,
    MAXPARAMS
  };
private:
  //!> parameter vector with parameters as in enum parameter_enum_t
  parameters_t params;

private:
  //!> names of each parameter
  static const ParameterNames_t paramNames;

  //!> static token of this potential type
  static const std::string potential_token;
};

#endif /* SERIALIZABLEPOTENTIALMOCK_HPP_ */
