/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the COPYING file or "Copyright notice" in builder.cpp for details.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>. 
 */

/*
 * SerializablePotentialMock.cpp
 *
 *  Created on: 23.11.2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "SerializablePotentialMock.hpp"

#include "CodePatterns/Assert.hpp"

#include <boost/assign.hpp>

using namespace boost::assign;

// static definitions
const SerializablePotential::ParameterNames_t SerializablePotentialMock::paramNames(1, std::string("dummy_constant"));

const std::string SerializablePotentialMock::potential_token("serializablepotentialmock");


void SerializablePotentialMock::setParameters(const parameters_t &_params)
{
  ASSERT( _params.size() == (size_t)1,
      "SerializablePotentialMock::setParameters() - not the right number of parameters.");
  params = _params;
}

