/*
 * molecule_pointcloud.cpp
 *
 *  Created on: Oct 5, 2009
 *      Author: heber
 */

#include "atom.hpp"
#include "config.hpp"
#include "info.hpp"
#include "memoryallocator.hpp"
#include "molecule.hpp"

/************************************* Functions for class molecule *********************************/

/** Returns a name for this point cloud, here the molecule's name.
 * \return name of point cloud
 */
const char * const molecule::GetName() const
{
  return name;
};

/** Determine center of all atoms.
 * \param *out output stream for debugging
 * \return pointer to allocated with central coordinates
 */
Vector *molecule::GetCenter() const
{
  Vector *center = DetermineCenterOfAll();
  return center;
};


/** PointCloud implementation of GoPoint
 * Uses atoms and STL stuff.
 */
TesselPoint* molecule::GetPoint() const
{
  return (*InternalPointer);
};

/** PointCloud implementation of GoToNext.
 * Uses atoms and STL stuff.
 */
void molecule::GoToNext() const
{
  if (InternalPointer != atoms.end())
    InternalPointer++;
};

/** PointCloud implementation of GoToFirst.
 * Uses atoms and STL stuff.
 */
void molecule::GoToFirst() const
{
  InternalPointer = atoms.begin();
};

/** PointCloud implementation of IsEmpty.
 * Uses atoms and STL stuff.
 */
bool molecule::IsEmpty() const
{
  return (empty());
};

/** PointCloud implementation of IsLast.
 * Uses atoms and STL stuff.
 */
bool molecule::IsEnd() const
{
  return (InternalPointer == atoms.end());
};

int molecule::GetMaxId() const {
  return getAtomCount();
}
