/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * defs.cpp
 *
 *  Created on: Aug 7, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Helpers/defs.hpp"

const double MYEPSILON=1e-13;   //!< machine epsilon precision
const double AtomicLengthToAngstroem = 0.52917721; //!< conversion factor from atomic length/bohrradius to angstroem
const double AtomicEnergyToKelvin = 315774.67;  //!< conversion factor from atomic energy to kelvin via boltzmann factor
const double KelvinToAtomicTemperature = 3.1668152e-06;    //!< conversion factor for Kelvin to atomic temperature (Hartree over k_B)
const double KelvinToeV = 8.6173422e-05;                   //!< conversion factor for Kelvin to Ht (k_B * T = energy), thus Boltzmann constant in eV/K
const double AtomicMassUnitsToeV = 931494088.;        //!< conversion factor for atomic weight in units to mass in eV
const double AtomicMassUnitsToHt = 34480864.;        //!< conversion factor for atomic weight in units to mass in Ht (protonmass/electronmass * electron_mass_in_Ht
const double ElectronMass_Ht = 18778.865;            //!< electron mass in Ht
const double ElectronMass_eV = 510998.903;           //!< electron mass in eV
const double Units2Electronmass = (AtomicMassUnitsToeV/ElectronMass_eV); //!< atomic mass unit in eV/ electron mass in eV = 1 822.88863
const double Atomictime2Femtoseconds = 0.024188843;     //!< Atomictime in fs

const char* VERSIONSTRING = "v1.0";

const char* LocalPath="./";

// various standard filenames
const char *DEFAULTCONFIG = "main_pcp_linux";    //!< default filename of config file
const char *CONVEXENVELOPE = "ConvexEnvelope.dat";    //!< default filename of convex envelope tecplot data file
const char *KEYSETFILE = "KeySets.dat";    //!< default filename of BOSSANOVA key sets file
const char *ADJACENCYFILE = "Adjacency.dat";    //!< default filename of BOSSANOVA adjacancy file
const char *TEFACTORSFILE = "TE-Factors.dat";    //!< default filename of BOSSANOVA total energy factors file
const char *FORCESFILE = "Forces-Factors.dat";    //!< default filename of BOSSANOVA force factors file
const char *HCORRECTIONSUFFIX = "Hcorrection.dat";    //!< default filename of BOSSANOVA H correction file (unwanted saturation interaction)
const char *FITCONSTANTSUFFIX = "FitConstant.dat";   //!< suffix of default filename of BOSSANOVA fit constants file (unwanted saturation interaction)
const char *SHIELDINGSUFFIX = "sigma_all.csv";                //!< default filename of BOSSANOVA shieldings file
const char *SHIELDINGPASSUFFIX = "sigma_all_PAS.csv";                 //!< default filename of BOSSANOVA shieldings PAS file
const char *ORDERATSITEFILE = "OrderAtSite.dat";    //!< default filename of BOSSANOVA Bond Order at each atom file
const char *ENERGYPERFRAGMENT = "EnergyPerFragment";    //!< default filename of BOSSANOVA Energy contribution Per Fragment file
const char *FRAGMENTPREFIX = "BondFragment";    //!< default filename prefix of BOSSANOVA fragment config and directories
const char *STANDARDCONFIG = "unknown.conf";    //!< default filename of standard config file
const char *STANDARDELEMENTSDB = "elements.db";    //!< default filename of elements data base with masses, Z, VanDerWaals radii, ...
const char *STANDARDVALENCEDB = "valence.db";    //!< default filename of valence number per element database
const char *STANDARDORBITALDB = "orbitals.db";    //!< default filename of orbitals per element database
const char *STANDARDHBONDDISTANCEDB = "Hbonddistance.db";    //!< default filename of typial bond distance to hydrogen database
const char *STANDARDHBONDANGLEDB = "Hbondangle.db";    //!< default filename of typial bond angle to hydrogen database

// some values
const double SOLVENTDENSITY_A = 0.6022142;
const double SOLVENTDENSITY_a0 = 0.089238936;


const int UPDATECOUNT = 10;  //!< update ten sites per BOSSANOVA interval

const int STD_MENU_LENGTH = 60;
const char STD_MENU_TITLE_SPACER = '=';
const char STD_SEPERATOR_SPACER = '-';

const char *MOLECUILDER_NAME = "Molecuilder";
