/*
 * InfiniteSolutionsException.hpp
 *
 *  Created on: May 28, 2010
 *      Author: crueger
 */

#ifndef INFINITESOLUTIONSEXCEPTION_HPP_
#define INFINITESOLUTIONSEXCEPTION_HPP_

#include "MathException.hpp"

template<class T>
class MultipleSolutionsException : public MathException
{
public:
  MultipleSolutionsException(std::string _file, int _line, const T& _solution) :
    MathException(_file,_line),
    solution(_solution)
  {}

  virtual ~MultipleSolutionsException() throw(){}

  virtual const char* what() const throw(){
    return "Multiple solutions possible....";
  }

  /**
   * use this method in case you don't care that there is more than one
   * solution and just any solution is fine
   */
  virtual T getAnySolution(){
    return solution;
  }

private:
  T solution;
};

#endif /* MULTIPLESOLUTIONSEXCEPTION_HPP_ */
