/*
 * QtMoleculeItemFactory.hpp
 *
 *  Created on: Jan 18, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEMFACTORY_HPP_
#define QTMOLECULEITEMFACTORY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Singleton.hpp"

#include <QList>

#include <string>

class molecule;

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"

/** This class is a factory for a list of QtMoleculeItem's.
 *
 * QtMoleculeList contains these per row, either a group item which combines
 * molecules of the same formula, or a molecule item which represents a single
 * molecule.
 */
class QtMoleculeItemFactory : public Singleton<QtMoleculeItemFactory>
{
  //!> grant Singleton access to cstor and dstor.
  friend class Singleton<QtMoleculeItemFactory>;
private:
  // private constructor and destructor due to singleton
  QtMoleculeItemFactory();
  virtual ~QtMoleculeItemFactory() {}

public:
  static const int COLUMNCOUNT;
  enum {NAME,VISIBILITY,ATOMCOUNT,FORMULA,OCCURRENCE,COLUMNTYPES_MAX} COLUMNTYPES;
  static const char *COLUMNNAMES[];

  /** Creates all QtMoleculeItem's that make up the row for a single molecule.
   *
   * \param _mol ref to molecule which is stored internally
   * \param _emitDirtyState callback function to model to inform about required state update
   * \return list of prepared items to be appended to a group item
   */
  QList<QStandardItem *> createMoleculeItems(
      const molecule *_mol,
      const QtMoleculeItem::emitDirtyState_t &_emitDirtyState);

  /** Creates all QtMoleculeItem's that make up a row of a group item.
   *
   * \param _formula chemical formula which describes all molecules in this group
   * \return list of prepared items to be appended to the invisibleRootItem()
   */
  QList<QStandardItem *> createGroupItems(const std::string &_formula);
};


#endif /* QTMOLECULEITEMFACTORY_HPP_ */
