/*
 * QtMoleculeItem_formula.hpp
 *
 *  Created on: Jan 18, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEM_FORMULA_HPP_
#define QTMOLECULEITEM_FORMULA_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"

#include <string>

#include "Formula.hpp"
#include "molecule.hpp"

class QtMoleculeItemFactory;

/** This class contains the formula of a molecule and keeps it up to date.
 *
 */
class QtMoleculeItem_formula : public QtMoleculeItem
{
  //!> only allow factory to instantiate items
  friend class QtMoleculeItemFactory;

  QtMoleculeItem_formula(
      const molecule * const _mol,
      emitDirtyState_t _emitDirtyState) :
        QtMoleculeItem(_mol, channellist_formula, QtMoleculeItem::NeedsMove, _emitDirtyState)
  {
    // cannot call pure virtual function in QtMoleculeItem's cstor
    internal_updateState();
  }

  /** Performs the update of the molecule's formula.
   *
   */
  void internal_updateState()
  {
    setText(QString(mol->getFormula().toString().c_str()));
  }

  //!> notification channels of molecule specific to this molecule item, required for update
  static const QtMoleculeItem::channellist_t channellist_formula;
};



#endif /* QTMOLECULEITEM_FORMULA_HPP_ */
