/*
 * QtMoleculeItem_name.hpp
 *
 *  Created on: Jan 18, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEM_NAME_HPP_
#define QTMOLECULEITEM_NAME_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"

#include "molecule.hpp"

class QtMoleculeItemFactory;

/** This class contains the name of a molecule and keeps it up to date.
 *
 */
class QtMoleculeItem_name : public QtMoleculeItem
{
  //!> only allow factory to instantiate items
  friend class QtMoleculeItemFactory;

  QtMoleculeItem_name(
      const molecule * const _mol,
      emitDirtyState_t _emitDirtyState) :
        QtMoleculeItem(_mol, channellist_name, QtMoleculeItem::DoesNotMove, _emitDirtyState)
  {
    // cannot call pure virtual function in QtMoleculeItem's cstor
    internal_updateState();
  }

  /** Performs the update of the molecule's name.
   *
   */
  void internal_updateState()
  {
    setText(QString(mol->getName().c_str()));
  }

  //!> notification channels of molecule specific to this molecule item, required for update
  static const QtMoleculeItem::channellist_t channellist_name;
};


#endif /* QTMOLECULEITEM_NAME_HPP_ */
