/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2016 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SubgraphEdgeUnitTest.cpp
 *
 *  Created on: Oct 03, 2016
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "SubgraphEdgeUnitTest.hpp"

#include <boost/assign.hpp>

#include "CodePatterns/Assert.hpp"

#include "Potentials/Subgraph/SubgraphEdge.hpp"

using namespace boost::assign;

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( SubgraphEdgeTest );


void SubgraphEdgeTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);

}


void SubgraphEdgeTest::tearDown()
{
}

/** UnitTest for TypeComparator()
 */
void SubgraphEdgeTest::TypeComparatorTest()
{
  SubgraphEdge arg( std::make_pair(1,2), std::make_pair(1,1) );
  SubgraphEdge otherarg( std::make_pair(1,2), std::make_pair(2,1) );
  SubgraphEdge anotherarg( std::make_pair(1,2), std::make_pair(1,2) );

  CPPUNIT_ASSERT( SubgraphEdge::TypeComparator(arg, otherarg) );
  CPPUNIT_ASSERT( !SubgraphEdge::TypeComparator(arg, anotherarg) );
  CPPUNIT_ASSERT( !SubgraphEdge::TypeComparator(otherarg, anotherarg) );
}

/** UnitTest for operator<()
 */
void SubgraphEdgeTest::ComparatorTest()
{
  SubgraphEdge zeroarg( std::make_pair(0,2), std::make_pair(3,1) );
  SubgraphEdge firstarg( std::make_pair(1,2), std::make_pair(1,1) );
  SubgraphEdge firstarg_latertype( std::make_pair(1,2), std::make_pair(2,1) );
  SubgraphEdge secondarg( std::make_pair(2,3), std::make_pair(1,2) );

  CPPUNIT_ASSERT( zeroarg < firstarg );
  CPPUNIT_ASSERT( zeroarg < firstarg_latertype );
  CPPUNIT_ASSERT( firstarg < firstarg_latertype );
  CPPUNIT_ASSERT( zeroarg < secondarg );
  CPPUNIT_ASSERT( firstarg < secondarg );
  CPPUNIT_ASSERT( firstarg_latertype < secondarg );
}

/** UnitTest for operator==()
 */
void SubgraphEdgeTest::EqualityTest()
{
  SubgraphEdge arg( std::make_pair(1,2), std::make_pair(1,1) );
  SubgraphEdge arg_different_type( std::make_pair(1,2), std::make_pair(1,2) );
  SubgraphEdge arg_different_index( std::make_pair(0,2), std::make_pair(1,1) );
  SubgraphEdge samearg( std::make_pair(1,2), std::make_pair(1,2) );

  CPPUNIT_ASSERT( !(arg == arg_different_type) );
  CPPUNIT_ASSERT( !(arg == arg_different_index) );
  CPPUNIT_ASSERT( arg == samearg );
}
