/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * WorkerOptions.cpp
 *
 *  Created on: 01.06.2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "WorkerOptions.hpp"

#include <unistd.h>

#include "CodePatterns/Log.hpp"

int WorkerOptions::parseServer(boost::program_options::variables_map &vm) {
  if (vm.count("server")) {
    server = vm["server"].as< std::string >();
    serverport = server.substr(server.find_last_of(':')+1, std::string::npos);
    server = server.substr(0, server.find_last_of(':'));
    try {
      boost::lexical_cast<size_t>(serverport);
    } catch (boost::bad_lexical_cast) {
      ELOG(1, "Could not interpret " << serverport << " as server:port.");
      return 255;
    }
    LOG(1, "INFO: Using " << server << ":" << serverport << " as server's address.");
  } else {
    ELOG(1, "Requiring server's address (host:port) to connect to.");
    return 255;
  }
  return 0;
}

int WorkerOptions::parseLocalhost(boost::program_options::variables_map &vm) {
  if (vm.count("hostname")) {
    hostname = vm["hostname"].as< std::string >();
    LOG(1, "INFO: Using " << hostname << " as host's name.");
  } else {
    char name[1024];
    if (gethostname(name, 1023) == 0) {
      hostname = name;
      LOG(1, "INFO: Using obtained hostname " << hostname << ".");
    } else {
      ELOG(1, "No hostname given and failed to determine automatically.");
      return 255;
    }
  }
  return 0;
}

int WorkerOptions::parseListenPort(boost::program_options::variables_map &vm) {
  if (vm.count("listen")) {
    try {
      listenport = vm["listen"].as< std::string >();
    } catch (boost::bad_lexical_cast) {
      ELOG(1, "Could not read " << vm["listen"].as< std::string >() << " as digits.");
      return 255;
    }
    LOG(1, "INFO: Using port " << listenport << " to listen to server connects.");
  } else {
    ELOG(1, "Requiring port to listen on .");
    return 255;
  }
  return 0;
}
