/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SignalOptions.cpp
 *
 *  Created on: 01.06.2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "SignalOptions.hpp"

#include "CodePatterns/Log.hpp"

int SignalOptions::parseSignals(boost::program_options::variables_map &vm)
{
  if (vm.count("signal")) {
    signals =  vm["signal"].as< std::vector<size_t> >();
  } else {
    LOG(0, "STATUS: No signals are caught.");
  }
  return 0;
}
