/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomShapeDescriptor.cpp
 *
 *  Created on: Jul 22, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "AtomShapeDescriptor.hpp"
#include "AtomShapeDescriptor_impl.hpp"

#include "atom.hpp"

AtomShapeDescriptor_impl::AtomShapeDescriptor_impl(const Shape &_shape) :
  shape(_shape)
{}

AtomShapeDescriptor_impl::~AtomShapeDescriptor_impl(){}

bool AtomShapeDescriptor_impl::predicate(std::pair<atomId_t,atom*> atom){
  return shape.isInside(atom.second->getPosition());
}


AtomDescriptor AtomByShape(const Shape &shape){
  return AtomDescriptor(AtomDescriptor::impl_ptr(new AtomShapeDescriptor_impl(shape)));
}
