/*
 * LinkedCellUnitTest.hpp
 *
 *  Created on: Apr 9, 2010
 *      Author: heber
 */

#ifndef LINKEDCELLUNITTEST_HPP_
#define LINKEDCELLUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>


class element;
class LinkedCell_deprecated;
class molecule;
class periodentafel;

/********************************************** Test classes **************************************/

class linkedcelltest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( linkedcelltest) ;
    CPPUNIT_TEST ( CheckBoundsTest );
    CPPUNIT_TEST ( GetCurrentCellTest );
    CPPUNIT_TEST ( GetRelativeToCurrentCellTest );
    CPPUNIT_TEST ( SetIndexToNodeTest );
    CPPUNIT_TEST ( SetIndexToVectorTest );
    CPPUNIT_TEST ( GetNeighbourBoundsTest );
    CPPUNIT_TEST ( GetallNeighboursTest );
    CPPUNIT_TEST ( GetPointsInsideSphereTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();

      void GetCurrentCellTest();
      void GetRelativeToCurrentCellTest();
      void SetIndexToNodeTest();
      void SetIndexToVectorTest();
      void CheckBoundsTest();
      void GetNeighbourBoundsTest();
      void GetallNeighboursTest();
      void GetPointsInsideSphereTest();

private:

      molecule *TestMolecule;
      const element *hydrogen;
      LinkedCell_deprecated *LC;
};


#endif /* LINKEDCELLUNITTEST_HPP_ */
