/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NonConvexEnvelopeAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "LinkedCell/linkedcell.hpp"
#include "LinkedCell/PointCloudAdaptor.hpp"
#include "molecule.hpp"
#include "Tesselation/boundary.hpp"
#include "Tesselation/tesselation.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "Actions/TesselationAction/NonConvexEnvelopeAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "NonConvexEnvelopeAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr TesselationNonConvexEnvelopeAction::performCall() {
  molecule * Boundary = NULL;
  bool Success = false;
  clock_t start,end;

  // obtain information
  getParametersfromValueStorage();

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    Boundary = iter->second;
    class Tesselation *T = NULL;
    const LinkedCell_deprecated *LCList = NULL;
    LOG(0, "Evaluating non-convex envelope of molecule." << Boundary->getId());
    LOG(1, "Using rolling ball of radius " << params.SphereRadius << " and storing tecplot data in " << params.filename << ".");
    LOG(1, "Specified molecule has " << Boundary->getAtomCount() << " atoms.");
    start = clock();
    PointCloudAdaptor< molecule > cloud(Boundary, Boundary->name);
    LCList = new LinkedCell_deprecated(cloud, params.SphereRadius*2.);
    Success = FindNonConvexBorder(Boundary, T, LCList, params.SphereRadius, params.filename.string().c_str());
    //FindDistributionOfEllipsoids(T, &LCList, N, number, params.filename.c_str());
    end = clock();
    LOG(0, "Clocks for this operation: " << (end-start) << ", time: " << ((double)(end-start)/CLOCKS_PER_SEC) << "s.");
    delete(LCList);
    delete(T);
  }
  if (Success)
    return Action::success;
  else
    return Action::failure;
}

Action::state_ptr TesselationNonConvexEnvelopeAction::performUndo(Action::state_ptr _state) {
//  TesselationNonConvexEnvelopeState *state = assert_cast<TesselationNonConvexEnvelopeState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr TesselationNonConvexEnvelopeAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool TesselationNonConvexEnvelopeAction::canUndo() {
  return false;
}

bool TesselationNonConvexEnvelopeAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
