/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * WorldTimeUnitTest.cpp
 *
 *  Created on: Oct 29, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <iostream>
#include <stdio.h>
#include <cstring>

#include "CodePatterns/Assert.hpp"

#include "WorldTime.hpp"

#include "WorldTimeUnitTest.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

//!< tremolo's standard time step is 1.0180505e-14 s which is ... in atomictime
const double TremolosTIME = 420.87606;

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( WorldTimeTest );


void WorldTimeTest::setUp()
{
  Time = WorldTime::getPointer();
};


void WorldTimeTest::tearDown()
{
  WorldTime::purgeInstance();
};

/** Tests whether CurrentTime is accessible
 */
void WorldTimeTest::CurrentTimeTest()
{
  // check default is 0
  CPPUNIT_ASSERT_EQUAL ((unsigned int)0, Time->getTime() );

  // set and check
  Time->setTime(10);
  CPPUNIT_ASSERT_EQUAL ((unsigned int)10, Time->getTime() );
};

/** Tests whether CurrentTime is accessible
 */
void WorldTimeTest::StepWidthTest()
{
  // check default is 0
  CPPUNIT_ASSERT_EQUAL (0., Time->getStepWidth() );

  // set and check
  Time->setStepWidth(TremolosTIME);
  CPPUNIT_ASSERT_EQUAL (TremolosTIME, Time->getStepWidth() );
};

