/*
 * WorldTime.hpp
 *
 *  Created on: Feb 7, 2011
 *      Author: heber
 */

#ifndef WORLDTIME_HPP_
#define WORLDTIME_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Singleton.hpp"

class WorldTimeTest;

class WorldTime : public Singleton<WorldTime>
{
  //!> own unit test should be friend to access private variables.
  friend class WorldTimeTest;

  //!> Make access to constructor and destructor possible from inside the singleton.
  friend class Singleton<WorldTime>;

  //!> Action is granted access to private setter.
  friend class WorldSetWorldTimeAction;
public:

  /** Getter for CurrentTime.
   *
   * @return CurrentTime
   */
  static unsigned int getTime()
    { return WorldTime::CurrentTime; }

  /** Setter for StepWidth.
   *
   * @param _step value to set StepWidth to
   */
  void setStepWidth(const double _width);
  /** Getter for StepWidth.
   *
   * @return StepWidth
   */
  double getStepWidth() const;

private:
  /** Setter for CurrentTime.
   *
   * Access to setter is granted to friends only. Time must not be modifiable
   * globally!
   *
   * @param _time value to set CurrentTime to
   */
  static void setTime(const unsigned int _time)
    { WorldTime::CurrentTime = _time; }

  static unsigned int CurrentTime;  //!< contains current time step
  double StepWidth; //!< contains width of one time step in atomic units

protected:
  /**
   * private constructor to ensure creation of the world using
   * the singleton pattern.
   */
  WorldTime();

  /**
   * private destructor to ensure destruction of the world using the
   * singleton pattern.
   */
  ~WorldTime();

};

#endif /* WORLDTIME_HPP_ */
