/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * WorldTime.cpp
 *
 *  Created on: Feb 7, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "WorldTime.hpp"

#include "CodePatterns/Singleton_impl.hpp"

unsigned int WorldTime::CurrentTime = 0;

WorldTime::WorldTime() :
  StepWidth(0.)
{}

WorldTime::~WorldTime()
{}

void WorldTime::setStepWidth(const double _width)
{
  StepWidth = _width;
}

double WorldTime::getStepWidth() const
{
  return StepWidth;
}

CONSTRUCT_SINGLETON(WorldTime)
