/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MenuDescription_ActionRegistry_ConsistencyUnitTest.cpp
 *
 *  Created on: Nov 25, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Actions/Action.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Actions/ActionTrait.hpp"
#include "World.hpp"
#include "WorldTime.hpp"

#include "MenuDescription_ActionRegistry_ConsistencyUnitTest.hpp"

using namespace MoleCuilder;

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( MenuDescription_ActionRegistry_ConsistencyTest );


void MenuDescription_ActionRegistry_ConsistencyTest::setUp()
{
  CPPUNIT_ASSERT_NO_THROW(AR = ActionRegistry::getPointer());
};


void MenuDescription_ActionRegistry_ConsistencyTest::tearDown()
{
  ActionRegistry::purgeInstance();
  // these come about because of the validators accessing them instantiated
  // by ActionRegistry. In ActionRegistryUnitTest we used stubs for them but
  // here we care whether default values are actually valid.
  World::purgeInstance();
  WorldTime::purgeInstance();
};

/** UnitTest for consistency.
 * we check that we have the same keys in each of MenuSet, MenuDescription and MenuNameMap.
 */
void MenuDescription_ActionRegistry_ConsistencyTest::ConsistencyCheck()
{
  std::set <std::string> MenuNames_from_ActionRegistry;

  // go through all Actions and gather menu names
  for (ActionRegistry::const_iterator iter = AR->getBeginIter();
      iter != AR->getEndIter();
      ++iter) {
    const std::string &MenuName = (iter->second)->Traits.getMenuName();
    MenuNames_from_ActionRegistry.insert(MenuName);
  }

  for (std::set <std::string>::const_iterator ARiter = MenuNames_from_ActionRegistry.begin();
      ARiter != MenuNames_from_ActionRegistry.end();
      ++ARiter) {
    std::string const MenuName = *ARiter;
    CPPUNIT_ASSERT_MESSAGE(MenuName
        +" cannot be found in the MenuDescription::MenuDescriptionsMap.\n"
        +"Have you added an entry to MenuDescriptionsMap of MenuDescription for this menu?",
        md.MenuDescriptionsMap->count(MenuName));
    CPPUNIT_ASSERT_MESSAGE(MenuName
        +" cannot be found in the MenuDescription::MenuPositionMap.\n"
        +"Have you added an entry to MenuPositionMap of MenuDescription for this menu?",
        md.MenuPositionMap->count(MenuName));
    CPPUNIT_ASSERT_MESSAGE(MenuName
        +" cannot be found in the MenuDescription::MenuNameMap.\n"
        +"Have you added an entry to MenuNameMap of MenuDescription for this menu?",
        md.MenuNameMap->count(MenuName));
  }
};
