/*
 * molecule_pointcloud.cpp
 *
 *  Created on: Oct 5, 2009
 *      Author: heber
 */

#include "atom.hpp"
#include "config.hpp"
#include "memoryallocator.hpp"
#include "molecule.hpp"

/************************************* Functions for class molecule *********************************/

/** Returns a name for this point cloud, here the molecule's name.
 * \return name of point cloud
 */
const char * const molecule::GetName() const
{
  return name;
};

/** Determine center of all atoms.
 * \param *out output stream for debugging
 * \return pointer to allocated with central coordinates
 */
Vector *molecule::GetCenter() const
{
  Vector *center = DetermineCenterOfAll();
  return center;
};

/** Return current atom in the list.
 * \return pointer to atom or NULL if none present
 */
TesselPoint *molecule::GetPoint() const
{
  if ((InternalPointer != start) && (InternalPointer != end))
    return InternalPointer;
  else
    return NULL;
};

/** Return pointer to one after last atom in the list.
 * \return pointer to end marker
 */
TesselPoint *molecule::GetTerminalPoint() const
{
  return end;
};

/** Go to next atom.
 * Stops at last one.
 */
void molecule::GoToNext() const
{
  if (InternalPointer != end)
    InternalPointer = InternalPointer->next;
};

/** Go to previous atom.
 * Stops at first one.
 */
void molecule::GoToPrevious() const
{
  if (InternalPointer->previous != start)
    InternalPointer = InternalPointer->previous;
};

/** Goes to first atom.
 */
void molecule::GoToFirst() const
{
  InternalPointer = start->next;
};

/** Goes to last atom.
 */
void molecule::GoToLast() const
{
  InternalPointer = end->previous;
};

/** Checks whether we have any atoms in molecule.
 * \return true - no atoms, false - not empty
 */
bool molecule::IsEmpty() const
{
  return (start->next == end);
};

/** Checks whether we are at the last atom
 * \return true - current atom is last one, false - is not last one
 */
bool molecule::IsEnd() const
{
  return (InternalPointer == end);
};
