/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * FileQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qlabel.h>
#include <Qt/qlineedit.h>
#include <Qt/qpushbutton.h>
#include <Qt/qstringlist.h>
#include <QtGui/QFileDialog>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"

#include "Parser/ParserTypes.hpp"
#include "Parser/FormatParserStorage.hpp"

QtDialog::FileQtQuery::FileQtQuery(Parameter<boost::filesystem::path> &_param, std::string _title, QBoxLayout *_parent, Dialog *_dialog) :
    QtQuery<boost::filesystem::path>(_param, _title),
    parent(_parent),
    dialog(_dialog)
{
  filenameLineEdit = new QLineEdit();
  filenameLineEdit->setText(QString());
  filenameLineEdit->setReadOnly(true);

  filenameLabel = new QLabel(QString("Input file:"));
  filenameLabel->setBuddy(filenameLineEdit);

  filedialogButton = new QPushButton("&Choose");
  theFileDialog = NULL;

  thisLayout = new QHBoxLayout();
  parent->addLayout(thisLayout);
  thisLayout->addWidget(filenameLabel);
  thisLayout->addWidget(filenameLineEdit);
  thisLayout->addWidget(filedialogButton);

  QObject::connect(filedialogButton,SIGNAL(clicked()),this,SLOT(showFileDialog()));
}

QtDialog::FileQtQuery::~FileQtQuery()
{
  if (theFileDialog != NULL)
    delete theFileDialog;
}

void QtDialog::FileQtQuery::onUpdate() {
  QStringList ListOfFilenames = theFileDialog->selectedFiles();
  std::cout << "Selected File is " << ListOfFilenames.at(0).toStdString() << std::endl;
  temp = ListOfFilenames.at(0).toStdString();
  filenameLineEdit->setText(QString::fromStdString(temp.string()));
  dialog->update();
}

void QtDialog::FileQtQuery::showFileDialog() {
  filedialogButton->setFlat(true);
  if (theFileDialog == NULL) {
    theFileDialog = new QFileDialog(NULL, tr("Open input file"), QString());
    // gather all possible suffixes
    QStringList filters;
    std::stringstream parsersuffixes;
    parsersuffixes << std::string("Config files (");
    for (ParserTypes t = ParserTypes_begin; t < ParserTypes_end; ++t){
      if (t != ParserTypes_begin)
        parsersuffixes << std::string(" ");
      parsersuffixes << std::string("*.") <<
          FormatParserStorage::getInstance().getSuffixFromType(t);
    }
    parsersuffixes << std::string(")");
    filters << tr(parsersuffixes.str().c_str());
    filters << tr("Data files (*.dat)");
    filters << tr("Any files (*)");
    theFileDialog->setNameFilters(filters);
    theFileDialog->setAcceptMode(QFileDialog::AcceptOpen);
    theFileDialog->setFileMode(QFileDialog::AnyFile);
    theFileDialog->setViewMode(QFileDialog::List);
  }
  theFileDialog->exec();

  onUpdate();
  filedialogButton->setFlat(false);
}

