/*
 * atom_particleinfo.cpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

#include "atom_particleinfo.hpp"
#include "memoryallocator.hpp"

/** Constructor of ParticleInfo.
 */
ParticleInfo::ParticleInfo() : nr(-1), name("Unknown") {
};

ParticleInfo::ParticleInfo(ParticleInfo *pointer) :
    nr(pointer->nr),
    name(pointer->name)
    {}


/** Destructor of ParticleInfo.
 */
ParticleInfo::~ParticleInfo()
{};

const string& ParticleInfo::getName() const{
  return name;
}

void ParticleInfo::setName(const string& _name){
  name = _name;
}

ostream & operator << (ostream &ost, const ParticleInfo &a)
{
  ost << "[" << a.getName() << "|" << &a << "]";
  return ost;
};

ostream & ParticleInfo::operator << (ostream &ost) const
{
  ost << "[" << name << "|" << this << "]";
  return ost;
};

