/*
 * atom_graphnode.cpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

#include "atom_graphnode.hpp"
#include "log.hpp"
#include "verbose.hpp"

/** Constructor of class GraphNode.
 */
GraphNode::GraphNode()
{
};

/** Destructor of class GraphNode.
 */
GraphNode::~GraphNode()
{
};

/** Output graph info of this atom.
 * \param *out output stream
 */
void GraphNode::OutputGraphInfo() const
{
  DoLog(2) && (Log() << Verbose(2) << "Atom " << getName() << " is " << ((SeparationVertex) ? "a" : "not a") << " separation vertex, components are ");
  OutputComponentNumber();
  DoLog(3) && (Log() << Verbose(3) << " with Lowpoint " << LowpointNr << " and Graph Nr. " << GraphNr << "." << endl);
};

/** Output a list of flags, stating whether the bond was visited or not.
 * Note, we make use of the last entry of the ComponentNr always being -1 if allocated.
 * \param *out output stream for debugging
 */
void GraphNode::OutputComponentNumber() const
{
  if (ComponentNr != NULL) {
    for (int i=0; ComponentNr[i] != -1; i++)
      DoLog(2) && (Log() << Verbose(2) << ComponentNr[i] << " ");
  }
};

