/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SimpleInserter.cpp
 *
 *  Created on: Feb 21, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "SimpleInserter.hpp"

#include "Atom/CopyAtoms/CopyAtomsInterface.hpp"

/** Constructor for class SimpleInserter.
 *
 */
SimpleInserter::SimpleInserter()
{}

/** Destructor for class SimpleInserter.
 *
 */
SimpleInserter::~SimpleInserter()
{}

/** Inserter operator that simply enacts ClusterInterface::clone().
 *
 * @param copyMethod functor for copying atoms
 * @param offset
 * @return always true
 */
bool SimpleInserter::operator()(CopyAtomsInterface &copyMethod, ClusterInterface::Cluster_impl cluster, const Vector &offset) const
{
  ClusterInterface::Cluster_impl newcluster(cluster->clone(copyMethod, offset));

  return (newcluster != NULL);
}
