/*
 * Inserter.hpp
 *
 *  Created on: Feb 21, 2012
 *      Author: heber
 */

#ifndef INSERTER_HPP_
#define INSERTER_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/shared_ptr.hpp>

#include "Filling/ClusterInterface.hpp"

class CopyAtomsInterface;
class Vector;

class InserterBase;

/** This class defines the interface for all derived classes.
 *
 * This is just a functor of an inserter function.
 *
 */
class Inserter
{
public:
  typedef boost::shared_ptr<InserterBase> impl_ptr;
  friend impl_ptr getInserterImpl(const Inserter&);

  Inserter(const Inserter &ptr);
  Inserter(impl_ptr);
  ~Inserter();
  bool operator()(CopyAtomsInterface &copyMethod, ClusterInterface::Cluster_impl cluster, const Vector &offset) const;

protected:
  impl_ptr getImpl() const;

private:
  impl_ptr impl;
};

Inserter::impl_ptr getInserterImpl(const Inserter &f);


#endif /* INSERTER_HPP_ */
