/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2014 Frederik Heber. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ShapeVolumeFillerPreparator.cpp
 *
 *  Created on: Sep 3, 2014
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "ShapeVolumeFillerPreparator.hpp"

#include <boost/bind.hpp>
#include <boost/function.hpp>

#include "Filling/Mesh/Mesh.hpp"
#include "Filling/Mesh/MeshAdaptor.hpp"
#include "Shapes/Shape.hpp"

ShapeVolumeFillerPreparator::ShapeVolumeFillerPreparator(molecule *_filler) :
  BaseFillerPreparator(_filler)
{}

ShapeVolumeFillerPreparator::~ShapeVolumeFillerPreparator()
{}

void ShapeVolumeFillerPreparator::addShapeMesh(
    const Shape &_shape,
    const unsigned int _nodes)
{

  MeshAdaptor::function_t fct =
      boost::bind(&Shape::getHomogeneousPointsInVolume,
          boost::cref(_shape),
          _nodes);
  mesh = new MeshAdaptor(fct);
}

