/*
 * PointCorrelationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/AnalysisAction/PointCorrelationAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "analysis_correlation.hpp"
#include "boundary.hpp"
#include "linkedcell.hpp"
#include "verbose.hpp"
#include "log.hpp"
#include "element.hpp"
#include "molecule.hpp"
#include "periodentafel.hpp"
#include "vector.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

const char AnalysisPointCorrelationAction::NAME[] = "point-correlation";

AnalysisPointCorrelationAction::AnalysisPointCorrelationAction() :
  Action(NAME)
{}

AnalysisPointCorrelationAction::~AnalysisPointCorrelationAction()
{}

void AnalysisPointCorrelation(std::vector< element *> &elements, Vector &position, double BinStart, double BinWidth, double BinEnd, string &outputname, string &binoutputname, bool periodic) {
  ValueStorage::getInstance().setCurrentValue("elements", elements);
  ValueStorage::getInstance().setCurrentValue("position", position);
  ValueStorage::getInstance().setCurrentValue("bin-start", BinStart);
  ValueStorage::getInstance().setCurrentValue("bin-width", BinWidth);
  ValueStorage::getInstance().setCurrentValue("bin-end", BinEnd);
  ValueStorage::getInstance().setCurrentValue("output-file", outputname);
  ValueStorage::getInstance().setCurrentValue("bin-output-file", binoutputname);
  ValueStorage::getInstance().setCurrentValue("periodic", periodic);
  ActionRegistry::getInstance().getActionByName(AnalysisPointCorrelationAction::NAME)->call(Action::NonInteractive);
};

Dialog* AnalysisPointCorrelationAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryVector("position", false, ValueStorage::getInstance().getDescription("position"));
  dialog->queryElements("elements", ValueStorage::getInstance().getDescription("elements"));
  dialog->queryDouble("bin-start", ValueStorage::getInstance().getDescription("bin-start"));
  dialog->queryDouble("bin-width", ValueStorage::getInstance().getDescription("bin-width"));
  dialog->queryDouble("bin-end", ValueStorage::getInstance().getDescription("bin-end"));
  dialog->queryString("output-file", ValueStorage::getInstance().getDescription("output-file"));
  dialog->queryString("bin-output-file", ValueStorage::getInstance().getDescription("bin-output-file"));
  dialog->queryBoolean("periodic", ValueStorage::getInstance().getDescription("periodic"));

  return dialog;
}

Action::state_ptr AnalysisPointCorrelationAction::performCall() {
  int ranges[3] = {1, 1, 1};
  double BinEnd = 0.;
  double BinStart = 0.;
  double BinWidth = 0.;
  molecule *Boundary = NULL;
  string outputname;
  string binoutputname;
  bool periodic;
  ofstream output;
  ofstream binoutput;
  std::vector< element *> elements;
  string type;
  Vector Point;
  BinPairMap *binmap = NULL;

  // obtain information
  ValueStorage::getInstance().queryCurrentValue("position", Point);
  ValueStorage::getInstance().queryCurrentValue("elements", elements);
  ValueStorage::getInstance().queryCurrentValue("bin-start", BinStart);
  ValueStorage::getInstance().queryCurrentValue("bin-width", BinWidth);
  ValueStorage::getInstance().queryCurrentValue("bin-end", BinEnd);
  ValueStorage::getInstance().queryCurrentValue("output-file", outputname);
  ValueStorage::getInstance().queryCurrentValue("bin-output-file", binoutputname);
  ValueStorage::getInstance().queryCurrentValue("periodic", periodic);

  // execute action
  output.open(outputname.c_str());
  binoutput.open(binoutputname.c_str());
  cout << "Point to correlate to is  " << Point << endl;
  CorrelationToPointMap *correlationmap = NULL;
  for(std::vector< element *>::iterator iter = elements.begin(); iter != elements.end(); ++iter)
    cout << "element is " << (*iter)->symbol << endl;
  std::vector<molecule*> molecules = World::getInstance().getSelectedMolecules();
  if (periodic)
    correlationmap  = PeriodicCorrelationToPoint(molecules, elements, &Point, ranges);
  else
    correlationmap = CorrelationToPoint(molecules, elements, &Point);
  OutputCorrelationToPoint(&output, correlationmap);
  binmap = BinData( correlationmap, BinWidth, BinStart, BinEnd );
  OutputCorrelation ( &binoutput, binmap );
  delete(binmap);
  delete(correlationmap);
  output.close();
  binoutput.close();
  return Action::success;
}

Action::state_ptr AnalysisPointCorrelationAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisPointCorrelationAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisPointCorrelationAction::canUndo() {
  return true;
}

bool AnalysisPointCorrelationAction::shouldUndo() {
  return true;
}

const string AnalysisPointCorrelationAction::getName() {
  return NAME;
}
