/*
 * FragmentForces.hpp
 *
 *  Created on: Oct 23, 2014
 *      Author: heber
 */

#ifndef FRAGMENTFORCES_HPP_
#define FRAGMENTFORCES_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>

#include "boost/serialization/export.hpp"
#include "boost/serialization/vector.hpp"

class FragmentForces : public std::vector< std::vector<double> >
{
  //!> let ostream access private parts
  friend std::ostream & operator<<(std::ostream &ost, const FragmentForces &forces);

public:
  //!> typedef for a  vector with three components
  typedef std::vector<double> force_t;
  //!> typedef for a vector containing the force per fragment atom
  typedef std::vector<force_t> forces_t;

  /** Default constructor for FragmentForces.
   *
   */
  FragmentForces() {}

  /** Equality operator.
   *
   * @param other other instance to check against
   * @return true - both are equal, false - some FragmentForces differ
   */
  bool operator==(const FragmentForces& other) const;

  bool operator!=(const FragmentForces& other) const
  {
    return (!(*this == other));
  }

  void operator+=(const FragmentForces& other);

private:
  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & boost::serialization::base_object<forces_t>(*this);
  }
};

/** Function to print eigenvalues to ostream.
 *
 * @param ost output stream
 * @param eigenvalues set of eigenvalues to print
 * @return ref to given ostream for concatenation
 */
std::ostream & operator<<(std::ostream &ost, const FragmentForces &forces);

// we need to give this class a unique key for serialization
// its is only serialized through its base class FragmentJob
BOOST_CLASS_EXPORT_KEY(FragmentForces)

#endif /* FRAGMENTFORCES_HPP_ */
