/*
 * Summation_impl.hpp
 *
 *  Created on: Jun 30, 2012
 *      Author: heber
 */

#ifndef SUMMATION_IMPL_HPP_
#define SUMMATION_IMPL_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/IteratorAdaptors.hpp"
#include "CodePatterns/Log.hpp"

#include "Fragmentation/Summation/printKeyNames.hpp"
#include "Fragmentation/Summation/ZeroInstance.hpp"

/** Constructor of class Summation.
 *
 */
template <class T>
Summation<T>::Summation(
    InputSets_t &indices,
    InputValues_t& values,
    SubsetMap::ptr _subsetmap) :
  subsetmap(_subsetmap)
{
  ASSERT( indices.size() == values.size(),
      "Summation<T>::Summation() - indices and values mismatch in size: "
      +toString(indices.size())+" != "+toString(values.size())+".");
  /// place each index
  /// create own map if none is given
  if (!subsetmap) {
    typename InputSets_t::iterator iter = indices.begin();
    IndexSetContainer container(*iter);
    for (; iter != indices.end(); ++iter)
      container.insert(*iter);
    subsetmap.reset(new SubsetMap(container));
  } else {
    LOG(2, "DEBUG: Using given SubsetMap.");
  }
  /// instantiate all SubSetValue's by requesting the IndexSet from the Subsetmap
  typename InputSets_t::iterator indexiter = indices.begin();
  typename InputValues_t::iterator valueiter = values.begin();
  for (;valueiter != values.end(); ++indexiter, ++valueiter) {
    LOG(2, "DEBUG: Adding set " << **indexiter << " with value " << *valueiter << ".");
    setvalues.addValue( *indexiter, *valueiter );
  }
  /// bind static lookup functions for SetValue<T>
  SetValue<T>::lookupSubset =
      boost::bind(&SubsetMap::getSubsets, boost::ref(*subsetmap), _1);
  SetValue<T>::lookupValue =
      boost::bind(&SetValueMap<T>::getValue, boost::ref(setvalues), _1);
}

template <class T>
T Summation<T>::operator()(const size_t level) const
{
  return Sum(level);
}

template <class T>
T Summation<T>::Sum(const size_t level) const
{
  typename SetValueMap<T>::const_iterator iter = setvalues.begin();
  T sum = ZeroInstance<T>();
  if (iter->first->size() <= level)
    sum = (iter->second)->getValue();
  LOG(3, "DEBUG: Value from subset "+toString(*(iter->second->getIndexSet()))
      +" is "+toString(sum)+".");
  for(++iter;(iter != setvalues.end()) && (iter->first->size() <= level); ++iter) {
    const T tempvalue = (iter->second)->getValue();
    sum += tempvalue;
    LOG(3, "DEBUG: Value from subset "+toString(*(iter->second->getIndexSet()))
        +" is "+toString(tempvalue)+".");
  }
  return sum;
}


#endif /* SUMMATION_IMPL_HPP_ */
