/*
 * Dialog.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#include <cassert>

#include "UIElements/Dialog.hpp"

#include "vector.hpp"

using namespace std;

Dialog::Dialog()
{
}

Dialog::~Dialog()
{
  list<Query*>::iterator iter;
  for(iter=queries.begin();iter!=queries.end();iter++){
    delete (*iter);
  }
}

void Dialog::registerQuery(Query *query){
  queries.push_back(query);
}

bool Dialog::display(){
  list<Query*>::iterator iter;
  bool retval = true;
  for(iter=queries.begin(); iter!=queries.end(); iter++){
    retval &= (*iter)->handle();
    // if any query fails (is canceled), we can end the handling process
    if(!retval)
      break;
  }
  if (retval){
    // if all queries succeeded we can set the targets to appropriate values
    for(iter=queries.begin(); iter!=queries.end(); iter++) {
      (*iter)->setResult();
    }
  }
  return retval;
}

/****************** Query types Infrastructure **************************/

// Base class
Dialog::Query::Query(string _title) :
    title(_title)
{}

Dialog::Query::~Query() {}

const std::string Dialog::Query::getTitle() const{
  return title;
}

// Int Queries

Dialog::IntQuery::IntQuery(string title,int *_target) :
    Query(title), target(_target)
{}

Dialog::IntQuery::~IntQuery() {}

void Dialog::IntQuery::setResult() {
  *target = tmp;
}

// String Queries

Dialog::StringQuery::StringQuery(string title,string *_target) :
    Query(title), target(_target)
{}

Dialog::StringQuery::~StringQuery() {};

void Dialog::StringQuery::setResult() {
  *target = tmp;
}

// Double Queries

Dialog::DoubleQuery::DoubleQuery(string title,double *_target) :
    Query(title), target(_target)
{}

Dialog::DoubleQuery::~DoubleQuery() {};

void Dialog::DoubleQuery::setResult() {
  *target = tmp;
}


// Molecule Queries

Dialog::MoleculeQuery::MoleculeQuery(string title, molecule **_target, MoleculeListClass *_molecules) :
    Query(title),
    tmp(0),
    molecules(_molecules),
    target(_target)

{}

Dialog::MoleculeQuery::~MoleculeQuery() {}

void Dialog::MoleculeQuery::setResult() {
  *target = tmp;
}

// Vector Queries

Dialog::VectorQuery::VectorQuery(std::string title,Vector *_target,const double *const _cellSize,bool _check) :
  Query(title),
  cellSize(_cellSize),
  check(_check),
  target(_target)
{
tmp = new Vector();
}

Dialog::VectorQuery::~VectorQuery()
{
  delete tmp;
}

void Dialog::VectorQuery::setResult() {
  *target = *tmp;
}

// Element Queries
Dialog::ElementQuery::ElementQuery(std::string title, element **_target) :
  Query(title),
  target(_target),
  tmp(0)
  {}

Dialog::ElementQuery::~ElementQuery(){}

void Dialog::ElementQuery::setResult(){
  *target=tmp;
}
