/*
 * ellipsoid.hpp
 *
 *	Created on: Jan 20, 2009
 *			Author: heber
 */

#ifndef ELLIPSOID_HPP_
#define ELLIPSOID_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cstdlib>

#include "boundary.hpp"
#include "vector.hpp"

double SquaredDistanceToEllipsoid(Vector &x, Vector &EllipsoidCenter, double *EllipsoidLength, double *EllipsoidAngle);
double SumSquaredDistance (const gsl_vector * x, void * params);
bool FitPointSetToEllipsoid(ofstream *out, Vector *set, int N, Vector *EllipsoidCenter, double *EllipsoidLength, double *EllipsoidAngle);
void PickRandomPointSet(ofstream *out, class Tesselation *T, Vector *&x, size_t PointsToPick);
void PickRandomNeighbouredPointSet(ofstream *out, class Tesselation *T, class LinkedCell *LC, Vector *&x, size_t PointsToPick);
void FindDistributionOfEllipsoids(ofstream *out, class Tesselation *T, class LinkedCell *LCList, int N, int number, const char *filename);

#endif /* ELLIPSOID_HPP_ */
