/*
 * ObservedValuesContainer_impl.hpp
 *
 *  Created on: Oct 29, 2015
 *      Author: heber
 */


#ifndef OBSERVEDVALUESCONTAINER_IMPL_HPP_
#define OBSERVEDVALUESCONTAINER_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ObservedValuesContainer.hpp"

#include "CodePatterns/Assert.hpp"

template <class T, typename id>
ObservedValuesContainer<T,id>::ObservedValuesContainer(
    const std::string _name,
    QtObservedInstanceBoard &_board) :
  NameOfType(_name),
  board(_board)
{}

template <class T, typename id>
typename T::ptr ObservedValuesContainer<T,id>::get(const id _id)
{
  typename CountedObservedValues_t::iterator iter = ObservedValues.find(_id);
  ASSERT( iter != ObservedValues.end(),
      "ObservedValuesContainer::getObservedValues() - no observed values present for "
      +NameOfType+" "+toString(_id));
  const ObservedValues_t &obsvalues = iter->second.first;
  // increase refcount
  ++(iter->second.second);
  typename T::ptr _molecule(new T(obsvalues, board));

  return _molecule;
}

template <>
typename QtObservedMolecule::ptr
ObservedValuesContainer<QtObservedMolecule,moleculeId_t>::get(const moleculeId_t _id)
{
  typename CountedObservedValues_t::iterator iter = ObservedValues.find(_id);
  ASSERT( iter != ObservedValues.end(),
      "ObservedValuesContainer::getObservedValues() - no observed values present for "
      +NameOfType+" "+toString(_id));
  const ObservedValues_t &obsvalues = iter->second.first;
  // increase refcount
  ++(iter->second.second);
  typename QtObservedMolecule::ptr _molecule(new QtObservedMolecule(obsvalues));

  return _molecule;
}

template <class T, typename id>
void ObservedValuesContainer<T,id>::yield(const id _id)
{
  typename CountedObservedValues_t::iterator iter = ObservedValues.find(_id);
  ASSERT( iter != ObservedValues.end(),
      "ObservedValuesContainer::returnObservedAtom() - no observed values present for "
      +NameOfType+" "+toString(_id));
  ASSERT( iter->second.second != 0,
      "ObservedValuesContainer::returnObservedAtom() - all instances for "
      +NameOfType+" "+toString(_id)+" have already been returned.");
  // decrease refcount
  --(iter->second.second);
  if (iter->second.second == 0) {
    // free instance
  }
}

template <class T, typename id>
ObservedValues_t ObservedValuesContainer<T,id>::getObservedValues(const id _id)
{
  ObservedValues_t returnvalues;
  typename CountedObservedValues_t::iterator iter = ObservedValues.find(_id);
  ASSERT(iter != ObservedValues.end(),
      "ObservedValuesContainer::getObservedValues() - "+NameOfType
      +" values not present for id "+toString(_id));
  if (iter->first == _id) {
    returnvalues = iter->second.first;
    ObservedValues.erase(iter);
  }
  return returnvalues;
}

template <class T, typename id>
void ObservedValuesContainer<T,id>::returnObservedValues(
    const id _id,
    ObservedValues_t &_observedvalues)
{
#ifndef NDEBUG
  std::pair<typename CountedObservedValues_t::iterator, bool> inserter =
#endif
      ObservedValues.insert(
          std::make_pair( _id, std::make_pair(_observedvalues,0) ) );
  ASSERT( inserter.second,
      "QtObservedInstanceBoard::returnAtomObservedValues() - could not insert ObservedValues for"
      +toString(_id)+".");
}

template <class T, typename id>
bool ObservedValuesContainer<T,id>::insert(const id _id, ObservedValues_t &_obsvalues)
{
  std::pair<typename CountedObservedValues_t::iterator, bool> inserter =
      ObservedValues.insert(
          std::make_pair( _id, std::make_pair(_obsvalues,0) ) );
  return inserter.second;
}

template <class T, typename id>
bool ObservedValuesContainer<T,id>::changeIdentifier(const id _oldid, const id _newid)
{
  const typename CountedObservedValues_t::iterator Colditer = ObservedValues.find(_oldid);
  const typename CountedObservedValues_t::iterator Cnewiter = ObservedValues.find(_newid);
  bool status = ((Colditer != ObservedValues.end()) && (Cnewiter == ObservedValues.end()));
  // change id here only if still present
  if (status) {
    {
      RefCountedObservedValues_t obsvalues = Colditer->second;
      ObservedValues.erase(Colditer);
      ObservedValues.insert( std::make_pair(_newid, obsvalues) );
    }
    return true;
  } else
    return false;
}

template <class T, typename id>
size_t ObservedValuesContainer<T,id>::getRefCount(const id _id) const
{
  typename CountedObservedValues_t::const_iterator iter = ObservedValues.find(_id);
  return iter->second.second;
}

template <class T, typename id>
bool ObservedValuesContainer<T,id>::erase(const id _id)
{
  typename CountedObservedValues_t::iterator iter = ObservedValues.find(_id);
  if (iter != ObservedValues.end()) {
    ObservedValues.erase(iter);
    return true;
  } else
    return false;
}

template <class T, typename id>
bool ObservedValuesContainer<T,id>::isPresent(const id _id) const
{
  typename CountedObservedValues_t::const_iterator iter = ObservedValues.find(_id);
  return (iter != ObservedValues.end());
}

#endif /* OBSERVEDVALUESCONTAINER_IMPL_HPP_ */
