/*
 * SubgraphDissectionAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/FragmentationAction/SubgraphDissectionAction.hpp"
#include "atom.hpp"
#include "config.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "stackclass.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char FragmentationSubgraphDissectionAction::NAME[] = "subgraph-dissect";

FragmentationSubgraphDissectionAction::FragmentationSubgraphDissectionAction() :
  Action(NAME)
{}

FragmentationSubgraphDissectionAction::~FragmentationSubgraphDissectionAction()
{}

Action::state_ptr FragmentationSubgraphDissectionAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryEmpty(NAME, MapOfActions::getInstance().getDescription(NAME));

  if(dialog->display()) {
    DoLog(1) && (Log() << Verbose(1) << "Dissecting molecular system into a set of disconnected subgraphs ... " << endl);
    // @TODO rather do the dissection afterwards
    MoleculeListClass *molecules = World::getInstance().getMolecules();
    molecules->DissectMoleculeIntoConnectedSubgraphs(World::getInstance().getPeriode(), World::getInstance().getConfig());
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr FragmentationSubgraphDissectionAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr FragmentationSubgraphDissectionAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool FragmentationSubgraphDissectionAction::canUndo() {
  return false;
}

bool FragmentationSubgraphDissectionAction::shouldUndo() {
  return false;
}

const string FragmentationSubgraphDissectionAction::getName() {
  return NAME;
}
