/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * VerboseAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

#include <iostream>
#include <string>

#include "Actions/CommandAction/VerboseAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "VerboseAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr CommandVerboseAction::performCall() {
  unsigned int oldverbosity = getVerbosity();

  // prepare undo state
  CommandVerboseState *UndoState = new CommandVerboseState(oldverbosity, params);

  if (oldverbosity != params.verbosity.get()) {
    // set new verbosity
    setVerbosity(params.verbosity.get());
    LOG(0, "Setting verbosity from " << oldverbosity << " to " << params.verbosity.get() << ".");
  } else {
    LOG(0, "Verbosity remains unchanged at " << oldverbosity << ".");
  }
  return ActionState::ptr(UndoState);
}

ActionState::ptr CommandVerboseAction::performUndo(ActionState::ptr _state) {
  CommandVerboseState *state = assert_cast<CommandVerboseState*>(_state.get());

  LOG(0, "Setting verbosity from " << state->params.verbosity.get() << " to " << state->oldverbosity << ".");
  setVerbosity(state->oldverbosity);

  return ActionState::ptr(_state);
}

ActionState::ptr CommandVerboseAction::performRedo(ActionState::ptr _state){
  CommandVerboseState *state = assert_cast<CommandVerboseState*>(_state.get());

  LOG(0, "Setting verbosity from " << state->oldverbosity << " to " << state->params.verbosity.get() << ".");
  setVerbosity(state->params.verbosity.get());

  return ActionState::ptr(_state);
}

bool CommandVerboseAction::canUndo() {
  return true;
}

bool CommandVerboseAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
