/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ParameterStorageUnitTest.cpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "ParameterStorageUnitTest.hpp"

#include <typeinfo>

#include "Parser/Parameters/ParameterStorage.hpp"
#include "Parameters/Parameter.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ParameterStorageTest );


void ParameterStorageTest::setUp()
{}


void ParameterStorageTest::tearDown()
{}

void ParameterStorageTest::instanceTest()
{
  std::vector<int> ValidValues;
  for( int i=1; i<=4; ++i)
    ValidValues.push_back(i);
  range<double> ValidRange(1., 4.);
  ParameterInterface *intParam = new Parameter<int>("intParam", ValidValues);
  ParameterInterface *doubleParam = new Parameter<double>("doubleParam", ValidRange);
  // note: delete is done by registry in tearDown ...

  // check that both are not present
  CPPUNIT_ASSERT_EQUAL(false, storage.isPresentByName("intParam"));
  CPPUNIT_ASSERT_EQUAL(false, storage.isPresentByName("doubleParam"));
  storage.registerInstance(intParam);
  storage.registerInstance(doubleParam);
  CPPUNIT_ASSERT_EQUAL(true, storage.isPresentByName("intParam"));
  CPPUNIT_ASSERT_EQUAL(true, storage.isPresentByName("doubleParam"));

  // retrieve instances and check address
  CPPUNIT_ASSERT_EQUAL(intParam, storage.getByName("intParam"));
  CPPUNIT_ASSERT_EQUAL(doubleParam, storage.getByName("doubleParam"));
}
