/*
 * ValueInterface.hpp
 *
 *  Created on: Sep 28, 2011
 *      Author: heber
 */

#ifndef VALUEINTERFACE_HPP_
#define VALUEINTERFACE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "ParameterExceptions.hpp"
#include "ValueAsString.hpp"

/** Interface definition for general parameter values.
 *
 */
template <class T>
class ValueInterface
{
public:
  virtual ~ValueInterface() {};

  // direct functions
  virtual bool isValid(const T & _value) const throw(ParameterValidatorException)=0;
  virtual const T & get() const throw(ParameterValueException)=0;
  virtual void set(const T & _value) throw(ParameterException)=0;
  virtual bool isSet() const=0;
};

#endif /* VALUEINTERFACE_HPP_ */
