/*
 * Parameter_impl.hpp
 *
 *  Created on: Apr 16, 2012
 *      Author: ankele
 */

#ifndef PARAMETER_IMPL_HPP_
#define PARAMETER_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Parameter.hpp"
#include "ParameterExceptions.hpp"


template<typename T>
Parameter<T>::Parameter(const Parameter<T> &instance) :
  ParameterInterface(instance.getName()),
  Value<T>(instance.getValidator())
{
  Value<T>::set(instance.Value<T>::get());
}

/** Constructor for class Parameter.
 *
 */
template<typename T>
Parameter<T>::Parameter() :
  ParameterInterface("__no_name__"),
  Value<T>()
{};

/** Constructor for class Parameter.
 *
 */
template<typename T>
Parameter<T>::Parameter(const std::string &_name) :
  ParameterInterface(_name),
  Value<T>()
{};

/** Constructor for class Parameter.
 *
 * @param _name name of this parameter
 * @param _value initial value to set
 */
template<typename T>
Parameter<T>::Parameter(const std::string &_name, const T &_value) :
  ParameterInterface(_name),
  Value<T>()
{
  Value<T>::set(_value);
};

/** Constructor for class Parameter.
 *
 * @param _name name of this parameter
 * @param _ValidRange valid range for this ContinuousValue
 */
template<typename T>
Parameter<T>::Parameter(const std::string &_name, const Validator<T> &_Validator) :
  ParameterInterface(_name),
  Value<T>(_Validator)
{};

/** Constructor for class Parameter.
 *
 * @param _name name of this parameter
 * @param _ValidRange valid range for this ContinuousValue
 * @param _value initial value to set
 */
template<typename T>
Parameter<T>::Parameter(const std::string &_name, const Validator<T> &_Validator, const T &_value) :
  ParameterInterface(_name),
  Value<T>(_Validator)
{
  Value<T>::set(_value);
};

/** Constructor for class Parameter.
 *
 * @param _name name of this parameter
 * @param _ValidRange valid range for this ContinuousValue
 */
template<typename T>
Parameter<T>::Parameter(const std::string &_name, const std::vector<T> &_ValidValues) :
  ParameterInterface(_name),
  Value<T>(_ValidValues)
{};

/** Constructor for class Parameter.
 *
 * @param _name name of this parameter
 * @param _ValidRange valid range for this ContinuousValue
 * @param _value initial value to set
 */
template<typename T>
Parameter<T>::Parameter(const std::string &_name, const std::vector<T> &_ValidValues, const T &_value) :
  ParameterInterface(_name),
  Value<T>(_ValidValues)
{
  Value<T>::set(_value);
};

/** Constructor for class Parameter.
 *
 * @param _name name of this parameter
 * @param _ValidRange valid range for this ContinuousValue
 */
template<typename T>
Parameter<T>::Parameter(const std::string &_name, const range<T> &_ValidRange) :
  ParameterInterface(_name),
  Value<T>(_ValidRange)
{};

/** Constructor for class Parameter.
 *
 * @param _name name of this parameter
 * @param _ValidRange valid range for this ContinuousValue
 * @param _value initial value to set
 */
template<typename T>
Parameter<T>::Parameter(const std::string &_name, const range<T> &_ValidRange, const T &_value) :
  ParameterInterface(_name),
  Value<T>(_ValidRange)
{
  Value<T>::set(_value);
};

/** Destructor for class Parameter.
 *
 */
template<typename T>
Parameter<T>::~Parameter()
{};

/** Catch call to Value<T>::getAsString() to add exception information.
 *
 * @return parameter value as string
 */
template<typename T>
inline const std::string Parameter<T>::getAsString() const throw(ParameterValueException)
{
  try {
    return Value<T>::getAsString();
  } catch(ParameterException &e) {
    e << ParameterName(ParameterInterface::getName());
    throw;
  }
}

/** Catch call to Value<T>::get() to add exception information.
 *
 * @return parameter value as string
 */
template<typename T>
inline const T & Parameter<T>::get() const throw(ParameterValueException)
{
  try {
    return Value<T>::get();
  } catch(ParameterException &e) {
    e << ParameterName(ParameterInterface::getName());
    throw;
  }
}

/** Catch call to Value<T>::set() to add exception information.
 *
 * @param _value value to set to
 */
template<typename T>
inline void Parameter<T>::set(const T & _value) throw(ParameterValueException)
{
  try {
    Value<T>::set(_value);
  } catch(ParameterException &e) {
    e << ParameterName(ParameterInterface::getName());
    throw;
  }
}

/** Catch call to Value<T>::set() to add exception information.
 *
 * @param _value value to set to
 */
template<typename T>
inline void Parameter<T>::setAsString(const std::string &_value) throw(ParameterValueException)
{
  try {
    Value<T>::setAsString(_value);
  } catch(ParameterException &e) {
    e << ParameterName(ParameterInterface::getName());
    throw;
  }
}

/** Compares this continuous value against another \a _instance.
 *
 * @param _instance other value to compare to
 * @return true - if contained ContinuousValue and name are the same, false - else
 */
template <class T>
bool Parameter<T>::operator==(const Parameter<T> &_instance) const throw(ParameterException)
{
  bool status = true;
  try {
    status = status &&
        (*dynamic_cast<const Value<T> *>(this) == dynamic_cast<const Value<T> &>(_instance));
    status = status && (ParameterInterface::getName() == _instance.ParameterInterface::getName());
  } catch(ParameterException &e) {
    e << ParameterName(ParameterInterface::getName());
    throw;
  }
  return status;
}

/** Creates a clone of this Parameter instance.
 *
 * @return cloned instance
 */
template<typename T>
inline ParameterInterface* Parameter<T>::clone() const
{
  Parameter<T> *instance = new Parameter<T>(ParameterInterface::getName(), Value<T>::getValidator());
  if (Value<T>::ValueSet)
    instance->set(Value<T>::get());
  return instance;
}


#endif /* Parameter_IMPL_HPP_ */
