/*
 * Parameter.hpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

#ifndef PARAMETERINTERFACE_HPP_
#define PARAMETERINTERFACE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "CodePatterns/Clone.hpp"

#include "Parameters/ValueAsString.hpp"

/** This interface represents a named Value.
 *
 */
class ParameterInterface :
  virtual public ValueAsString,
  public Clone<ParameterInterface>
{
public:
  ParameterInterface(const std::string &_name) : name(_name) {}
  virtual ~ParameterInterface() {}

  const std::string &getName() const { return name; }

  virtual ParameterInterface* clone() const=0;

private:
  ParameterInterface();

private:
  const std::string name;
};


#endif /* PARAMETERINTERFACE_HPP_ */
