/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ChangeElementAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomIdDescriptor.hpp"
#include "Atom/atom.hpp"
#include "Element/element.hpp"
#include "CodePatterns/Log.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "CodePatterns/Verbose.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <map>
#include <string>

#include "Actions/AtomAction/ChangeElementAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "ChangeElementAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr AtomChangeElementAction::performCall() {
  atom *first = NULL;
  molecule *mol = NULL;

  // create undo state
  ElementMap Elements;
  for (World::AtomSelectionIterator iter = World::getInstance().beginAtomSelection(); iter != World::getInstance().endAtomSelection(); ++iter) {
    Elements.insert(std::pair<int, const element *> (iter->second->getId(), iter->second->getType()));
  }
  AtomChangeElementState *UndoState = new AtomChangeElementState(Elements, params);

  for (World::AtomSelectionIterator iter = World::getInstance().beginAtomSelection(); iter != World::getInstance().endAtomSelection(); ++iter) {
    first = iter->second;
    LOG(1, "Changing atom " << *first << " to element " << *params.elemental.get() << ".");
    first->setType(params.elemental.get());
  }
  return ActionState::ptr(UndoState);
}

ActionState::ptr AtomChangeElementAction::performUndo(ActionState::ptr _state) {
  AtomChangeElementState *state = assert_cast<AtomChangeElementState*>(_state.get());
  atom *first = NULL;
  molecule *mol = NULL;

  for(ElementMap::const_iterator iter = state->Elements.begin(); iter != state->Elements.end(); ++iter) {
    first = World::getInstance().getAtom(AtomById(iter->first));
    first->setType(iter->second);
  }

  return ActionState::ptr(_state);
}

ActionState::ptr AtomChangeElementAction::performRedo(ActionState::ptr _state){
  AtomChangeElementState *state = assert_cast<AtomChangeElementState*>(_state.get());
  atom *first = NULL;
  molecule *mol = NULL;

  for(ElementMap::const_iterator iter = state->Elements.begin(); iter != state->Elements.end(); ++iter) {
    first = World::getInstance().getAtom(AtomById(iter->first));
    first->setType(state->params.elemental.get());
  }

  return ActionState::ptr(_state);
}

bool AtomChangeElementAction::canUndo() {
  return true;
}

bool AtomChangeElementAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
