/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * QtMenuPipe.cpp
 *
 *  Created on: Nov 5, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qaction.h>

#include "CodePatterns/MemDebug.hpp"
#include "CodePatterns/Log.hpp"

#include "QtMenuPipe.hpp"

#include "Actions/Action.hpp"
#include "Actions/ActionExceptions.hpp"
#include "Actions/ActionQueue.hpp"

using namespace MoleCuilder;

QtMenuPipe::QtMenuPipe(const std::string &_ActionName, QAction *_action) :
    ActionName(_ActionName), theAction(_action)
{}

QtMenuPipe::~QtMenuPipe() {
  delete theAction;
}

void QtMenuPipe::called() {
  Action* action = ActionQueue::getInstance().getActionRegistry().getActionByName(ActionName);
  try{
    action->call();
  }catch(ActionFailureException e){
    ELOG(1, "Action failed or cancelled");
  }
}
