/*
 * GLMoleculeObject.hpp
 *
 *  This is based on the Qt3D example "teaservice", specifically meshobject.h.
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

#ifndef GLMOLECULEOBJECT_HPP_
#define GLMOLECULEOBJECT_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <QtCore/qobject.h>
#include <QtGui/qevent.h>

#include <Qt3D/qglpainter.h>
#include <Qt3D/qglabstractscene.h>

class QGLView;
class QGLSceneNode;
class GLMoleculeScene;

/** This class represents a single object within a molecule, e.g. atom or bond.
 *
 */
class GLMoleculeObject : public QObject
{
   Q_OBJECT

   //!> Allow it to call cleanMaterialMap()
   friend class GLWorldScene;
public:
   explicit GLMoleculeObject(QGLSceneNode *GLMoleculeObject, QObject *parent=0);
   explicit GLMoleculeObject(QGLAbstractScene *scene, QObject *parent=0);
   virtual ~GLMoleculeObject();

   QVector3D position() const { return m_position; }
   void setPosition(const QVector3D& value) { m_position = value; }

   qreal scale() const { return m_scale; }
   void setScale(qreal value) { m_scale = value; }

   qreal rotationAngle() const { return m_rotationAngle; }
   void setRotationAngle(qreal value) { m_rotationAngle = value; }

   QVector3D rotationVector() const { return m_rotationVector; }
   void setRotationVector(const QVector3D& value) { m_rotationVector = value; }

   QGLMaterial *material() const { return m_material; }
   void setMaterial(QGLMaterial *value)
       { m_material = value; m_hoverMaterial = value; }

   QGLMaterial *hoverMaterial() const { return m_hoverMaterial; }
   void setHoverMaterial(QGLMaterial *value) { m_hoverMaterial = value; }

   QGLAbstractEffect *effect() const { return m_effect; }
   void setEffect(QGLAbstractEffect *value) { m_effect = value; }

   int objectId() const { return m_objectId; }
   void setObjectId(int id) { m_objectId = id; }

   void initialize(QGLView *view, QGLPainter *painter);
   void draw(QGLPainter *painter);

signals:
   void pressed();
   void released();
   void clicked();
   void doubleClicked();
   void hoverChanged();

protected:
   bool event(QEvent *e);

   static QGLMaterial* getMaterial(size_t);
   static void cleanMaterialMap();

   typedef std::map< size_t, QGLMaterial *> ElementMaterialMap;
   static ElementMaterialMap ElementNoMaterialMap;

private:

   QGLSceneNode *m_mesh;
   QGLSceneNode *m_GLMoleculeObject;
   QGLAbstractScene *m_scene;
   QVector3D m_position;
   qreal m_scale;
   qreal m_rotationAngle;
   QVector3D m_rotationVector;
   QGLMaterial *m_material;
   QGLMaterial *m_hoverMaterial;
   QGLMaterial *m_selectionMaterial;
   QGLAbstractEffect *m_effect;
   int m_objectId;
   bool m_hovering;
};


#endif /* GLMOLECULEOBJECT_HPP_ */
