/*
 * atom_bondedparticleinfo.hpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

#ifndef ATOM_BONDEDPARTICLEINFO_HPP_
#define ATOM_BONDEDPARTICLEINFO_HPP_


using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "atom_observable.hpp"

#include <list>

/****************************************** forward declarations *****************************/

class bond;
class BondedParticle;

#define BondList list<bond *>

/********************************************** declarations *******************************/

class BondedParticleInfo  : public virtual AtomObservable {
  friend class BondedParticle;
public:
  unsigned char AdaptiveOrder;  //!< current present bond order at site (0 means "not set")
  bool MaxOrder;  //!< whether this atom as a root in fragmentation still creates more fragments on higher orders or not

  BondedParticleInfo();
  virtual ~BondedParticleInfo();

  /** Pushes back another step in all trajectory vectors.
   *
   * This allows to extend all trajectories contained in different classes
   * consistently. This is implemented by the topmost class which calls the
   * real functions, \sa AppendTrajectoryStep(), by all necessary subclasses.
   */
  virtual void UpdateSteps()=0;

  /** Const accessor to ListOfBonds of WorldTime::CurrentTime.
   *
   * @return ListOfBonds[WorldTime::CurrentTime]
   */
  const BondList& getListOfBonds() const;

  /** Accessor to ListOfBonds of WorldTime::CurrentTime.
   *
   * Note, new empty BondList is returned if array entry at upper boundary is
   * accessed. Beyond std will issue exception due to out-of-range access.
   *
   * @return ListOfBonds[WorldTime::CurrentTime]
   */
//  BondList& getListOfBonds();

  /** Const Accessor ListOfBonds of any present time step.
   *
   * @param _step time step to access
   * @return ListOfBonds[_step].
   */
  const BondList& getListOfBondsAtStep(unsigned int _step) const;

  /** Accessor ListOfBonds of any present time step.
   *
   * Note, new empty BondList is returned if array entry at upper boundary is
   * accessed. Beyond std will issue exception due to out-of-range access.
   *
   * @param _step time step to access
   * @return ListOfBonds[_step].
   */
//  BondList& getListOfBondsAtStep(unsigned int _step);

protected:
  /** Function used by this and inheriting classes to extend the ListOfBonds
   * vector.
   */
  void AppendTrajectoryStep();

  std::vector<BondList> ListOfBonds; //!< list of all bonds
  static BondList emptyList;  //!< empty list to return when step is not present
};


#endif /* ATOM_BONDEDPARTICLEINFO_HPP_ */
