/*
 * atom_bondedparticle.hpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

#ifndef ATOM_BONDEDPARTICLE_HPP_
#define ATOM_BONDEDPARTICLE_HPP_


using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <fstream>
#include <list>

#include "atom_atominfo.hpp"
#include "atom_bondedparticleinfo.hpp"
#include "atom_particleinfo.hpp"

/****************************************** forward declarations *****************************/

class bond;

/********************************************** declarations *******************************/

class BondedParticle : public BondedParticleInfo, public virtual ParticleInfo, public virtual AtomInfo {
public:
  BondedParticle();
  virtual ~BondedParticle();

  const bond * addBond(const unsigned int _step, BondedParticle* Partner);
  void removeBond(bond *binder);
  void removeAllBonds();
  bool IsBondedTo(const unsigned int _step, BondedParticle * const BondPartner) const;
  void ClearBondsAtStep(const unsigned int _step);
  int CountBonds() const;
  int CorrectBondDegree();
  void resetBondDegree();
  void OutputBondOfAtom(std::ostream &ost) const;
  void OutputAdjacency(ofstream * const AdjacencyFile) const;
  void OutputBonds(ofstream * const BondFile) const;
  void OutputOrder(ofstream *file) const;

  std::ostream & operator << (std::ostream &ost) const;

protected:
  bool RegisterBond(const unsigned int _step, bond *Binder);
  bool UnregisterBond(bond *Binder);
  void UnregisterAllBond(const unsigned int _step);

  int ContainsBondAtStep(bond *Binder) const;

};

std::ostream & operator << (std::ostream &ost, const BondedParticle &a);

#endif /* ATOM_BONDEDPARTICLE_HPP_ */
