/*
 * WorkerPool.hpp
 *
 *  Created on: 22.02.2012
 *      Author: heber
 */

#ifndef WORKERPOOL_HPP_
#define WORKERPOOL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>
#include <set>
#include <string>

#include "WorkerAddress.hpp"

class FragmentQueue;
class WorkerPoolTest;

/** Class WorkerPool contains a number of PoolWorkers that connect to it
 * and wait for jobs to be sent to them. The class manages this pool of
 * workers.
 *
 */
class WorkerPool
{
  //!> grant unit test access
  friend class WorkerPoolTest;
public:
  WorkerPool();
  ~WorkerPool();

  bool addWorker(const WorkerAddress &address);
  bool presentInPool(const WorkerAddress &address) const;
  bool presentIdleWorkers() const {
    return !idle_queue.empty();
  }
  WorkerAddress getNextIdleWorker();
  bool isWorkerBusy(const WorkerAddress &address) const;
  bool removeWorker(const WorkerAddress& address);
  void unmarkWorkerBusy(const WorkerAddress &address);

private:
  //!> typedef of the priority in the idle queue of a worker
  typedef size_t priority_t;

  //!> typedef for the worker queue being a map with priority and address of worker
  typedef std::multimap<priority_t, WorkerAddress> Idle_Queue_t;

  //!> typedef for the worker queue being a map with priority and address of worker
  typedef std::map<WorkerAddress, priority_t> Busy_Queue_t;

  //!> typedef for the pool of workers being a set to keep only unique addresses
  typedef std::set<WorkerAddress> Pool_t;

private:
  void markWorkerBusy(Idle_Queue_t::iterator &iter);
  void removeAllWorkers();

private:
  //!> static for defining default priority for new workers
  static priority_t default_priority;

  //!> empty address in case queue is idle
  static WorkerAddress emptyAddress;

  //!> pool of all worker addresses to connect to and work on jobs
  Pool_t pool;

  //!> pool of worker addresses to connect to and work on jobs
  Idle_Queue_t idle_queue;

  //!> pool of worker addresses to connect to and work on jobs
  mutable Busy_Queue_t busy_queue;
};

#endif /* WORKERPOOL_HPP_ */
