/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculesTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <iostream>

#include <Descriptors/MoleculeDescriptor.hpp>
#include <Descriptors/MoleculeIdDescriptor.hpp>
#include "TextUI/Query/TextQuery.hpp"

#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"


TextDialog::MoleculesTextQuery::MoleculesTextQuery(string title, std::string _description) :
    Dialog::MoleculesQuery(title,_description)
{}

TextDialog::MoleculesTextQuery::~MoleculesTextQuery() {}

bool TextDialog::MoleculesTextQuery::handle() {
  int idxOfMol=-1;
  std::cout << getDescription() << ": ";
  std::string line;
  getline(std::cin,line);
  // dissect by " "
  std::string::iterator olditer = line.begin();
  for(string::iterator iter = line.begin(); iter != line.end(); ++iter) {
    if (*iter == ' ') {
      std::istringstream stream(string(iter, olditer));
      stream >> idxOfMol;
      temp = World::getInstance().getMolecule(MoleculeById(idxOfMol));
      if(!temp && idxOfMol!=-1){
        std::cout << "Invalid Molecule Index" << idxOfMol << std::endl;
        break;
      }
      tmp.push_back(temp);
      olditer = iter;
    }
  }
  if (olditer != line.begin()) { // insert last part also
    std::istringstream stream(string(olditer, line.end()));
    stream >> idxOfMol;
    temp = World::getInstance().getMolecule(MoleculeById(idxOfMol));
    if(!temp && idxOfMol!=-1){
      std::cout << "Invalid Molecule Index" << idxOfMol << std::endl;
      tmp.push_back(temp);
    }
  }

  return (idxOfMol!=-1);
}

