/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2014 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * AverageMoleculeForceAction.cpp
 *
 *  Created on: Aug 26, 2014
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "Atom/atom.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "Actions/AnalysisAction/AverageMoleculeForceAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "AverageMoleculeForceAction.def"
#include "Action_impl_pre.hpp"

/** =========== define the function ====================== */
ActionState::ptr AnalysisAverageMoleculeForceAction::performCall() {
  if (const_cast<const World &>(World::getInstance()).beginMoleculeSelection() ==
      const_cast<const World &>(World::getInstance()).endMoleculeSelection()) {
    STATUS("You have not selected any molecules.");
    return Action::failure;
  }
  // execute action
  for (World::MoleculeSelectionConstIterator moliter = World::getInstance().beginMoleculeSelection();
      moliter != World::getInstance().endMoleculeSelection(); ++moliter) {
    const molecule * const mol = moliter->second;

    // sum up
    Vector AverageForce(zeroVec);
    size_t No = 0;
    for (molecule::const_iterator atomiter = mol->begin();
        atomiter != mol->end(); ++atomiter) {
      AverageForce += (*atomiter)->getAtomicForce();
      ++No;
    }
    AverageForce *= 1./(double)No;
    LOG(0, "INFO: The average force for molecule " << mol->getName()
        << " is " << AverageForce);
  }
  return Action::success;
}

ActionState::ptr AnalysisAverageMoleculeForceAction::performUndo(ActionState::ptr _state) {
  return Action::success;
}

ActionState::ptr AnalysisAverageMoleculeForceAction::performRedo(ActionState::ptr _state){
  return Action::success;
}

bool AnalysisAverageMoleculeForceAction::canUndo() {
  return true;
}

bool AnalysisAverageMoleculeForceAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
