/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomDataValidator.cpp
 *
 *  Created on: May 14, 2012
 *      Author: ankele
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "AtomDataValidator.hpp"

#include "Parser/TremoloParser.hpp"

bool AtomDataValidator::isValid(const std::string & _value) const
{
  return FormatParser< tremolo >::testParseAtomDataKeysLine(_value);
}

bool AtomDataValidator::operator==(const Validator<std::string> &_instance) const
{
  const AtomDataValidator *inst =
      dynamic_cast<const AtomDataValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< std::string >* AtomDataValidator::clone() const
{
  Validator< std::string > *inst =
      new AtomDataValidator();
  return inst;
}




