/*
 * QtQueryListPipe.hpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

#ifndef QTQUERYLISTPIPE_HPP_
#define QTQUERYLISTPIPE_HPP_

#include <boost/lexical_cast.hpp>

using boost::lexical_cast;
using boost::bad_lexical_cast;

template<typename T> QtQueryListPipe<T>::QtQueryListPipe(std::vector<T> *_content, QtDialog *_dialog, QLineEdit *_inputBox, QListWidget *_inputList, QPushButton *_AddButton, QPushButton *_RemoveButton) :
  content(_content),
  dialog(_dialog),
  inputBox(_inputBox),
  inputList(_inputList),
  AddButton(_AddButton),
  RemoveButton(_RemoveButton)
{}

template<typename T> QtQueryListPipe<T>::~QtQueryListPipe()
{}

template<typename T> void QtQueryListPipe<T>::IntegerEntered(const QString&)
{
  AddButton->setEnabled(true);
}

template<typename T> void QtQueryListPipe<T>::IntegerSelected()
{
  if (inputList->selectedItems().empty())
    RemoveButton->setEnabled(false);
  else
    RemoveButton->setEnabled(true);
}

template<typename T> void QtQueryListPipe<T>::AddInteger() {
  // type-check
  std::string text = inputBox->text().toStdString();
  int number = 0;
  try {
    number = boost::lexical_cast<int>(text);
  } catch (boost::bad_lexical_cast&) {
    return;
  };
  // add item to both
  inputList->addItem(QString(number));
  AddValue(number);
}

template<typename T> void QtQueryListPipe<T>::AddValue(T item) {
  content->push_back(item);

  dialog->update();
}

template<typename T> void QtQueryListPipe<T>::RemoveInteger() {
  QList<QListWidgetItem *> items = inputList->selectedItems();
  for (QList<QListWidgetItem *>::iterator iter = items.begin(); !items.empty(); iter = items.begin()) {
    // obtain which position item has (by making it current item)
    inputList->setCurrentItem(*iter);
    // remove
    QtQueryListPipe<T>::RemoteRow(inputList->currentRow()); // template parameters needs to be known, such that compiler knows which to call
    inputList->removeItemWidget(*iter);
  }
}

template<typename T> void QtQueryListPipe<T>::RemoveRow(int row) {
  int counter = 0;
  typename std::vector<T>::iterator iter = content->begin();
  for (; iter != content->end(); ++iter)
    if (counter++ == row)
      break;
  if (iter != content->end())
      content->erase(iter);
}


#endif /*  QTQUERYLISTPIPE_HPP_  */
