/*
 * TranslateAction.hpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#ifndef TRANSLATEACTION_HPP
#define TRANSLATEACTION_HPP

#include "Actions/Action.hpp"
#include "Actions/Process.hpp"
#include "LinearAlgebra/Vector.hpp"

class MoleculeListClass;

void MoleculeTranslate(Vector &x, bool periodic);

class MoleculeTranslateAction : public Action {
  friend void MoleculeTranslate(Vector &x, bool periodic);

public:
  MoleculeTranslateAction();
  virtual ~MoleculeTranslateAction();

  bool canUndo();
  bool shouldUndo();

  virtual const std::string getName();
protected:
  virtual Dialog * fillDialog(Dialog *dialog);
private:
  virtual Action::state_ptr performCall();
  virtual Action::state_ptr performUndo(Action::state_ptr);
  virtual Action::state_ptr performRedo(Action::state_ptr);

  static const char NAME[];
};


#endif // TRANSLATEACTION_HPP
